% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_KEGG_map}
\alias{plot_KEGG_map}
\title{plot_KEGG_map}
\usage{
plot_KEGG_map(
  ko_stat,
  map_id = "map00780",
  modulelist = NULL,
  type = "pathway",
  feature = "ko",
  color_var = "Z_score",
  save_dir,
  color = c("seagreen", "grey", "orange")
)
}
\arguments{
\item{ko_stat}{ko_stat result from \code{\link{pvalue2zs}} or result of `get_reporter_score`}

\item{map_id}{the pathway or module id}

\item{modulelist}{NULL or customized modulelist dataframe, must contain "id","K_num","KOs","Description" columns. Take the `KOlist` as example, use \code{\link{custom_modulelist}}.}

\item{type}{"pathway" or "module" for default KOlist for microbiome, "CC", "MF", "BP", "ALL" for default GOlist for homo sapiens. And org in listed in 'https://www.genome.jp/kegg/catalog/org_list.html' such as "hsa" (if your kodf is come from a specific organism, you should specify type here).}

\item{feature}{one of "ko", "gene", "compound"}

\item{color_var}{use which variable to color}

\item{save_dir}{where to save the png files}

\item{color}{color}
}
\value{
png files
}
\description{
plot_KEGG_map
}
\examples{
message("The following example will download some files, run yourself:")
\donttest{
if (requireNamespace("pathview")) {
  output_dir <- tempdir()
  data("reporter_score_res")
  plot_KEGG_map(reporter_score_res$ko_stat,
    map_id = "map00780", type = "pathway",
    feature = "ko", color_var = "Z_score", save_dir = output_dir
  )
}
}
}
\references{
https://zhuanlan.zhihu.com/p/357687076
}
