% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get.sim.tl}
\alias{get.sim.tl}
\title{\eqn{\tau}{tau}-leaping simulation algorithm}
\usage{
get.sim.tl(Yt, theta, S, s2 = 0, tau = 1, rct.lst, verbose = TRUE)
}
\arguments{
\item{Yt}{starting point of the trajectory}

\item{theta}{vector parameter for the reactions.}

\item{S}{length of the simulated trajectory.}

\item{s2}{noise variance (defaults to 0).}

\item{tau}{time interval length (defaults to 1).}

\item{rct.lst}{list of biochemical reactions.}

\item{verbose}{(defaults to TRUE) Logical value. If TRUE, then information messages
on the simulation progress are printed to the console.}
}
\value{
A \eqn{S \times p}{S by p} dimensional matrix of the simulated trajectory.
}
\description{
Simulate a trajectory of length S for a stochastic reaction network.
}
\details{
This function allows to simulate a trajectory of a single clone given an
initial conditions \eqn{Y_0}{Y_0} for the cell counts, and obeying to a particular cell differentiation network
defined by a net-effect (stoichiometric) matrix \eqn{V}{V} and an hazard function \eqn{h()}{h()}.
The function allows to consider only three cellular events, such as
cell duplication (\eqn{Y_{it} \rightarrow 1}{Y_{it} -> 1}), cell death (\eqn{Y_{it} \rightarrow \emptyset}{Y_{it} -> 0})
and cell differentiation (\eqn{Y_{it} \rightarrow Y_{jt}}{Y_{it} -> Y_{jt}}) for a clone-specific time counting process
\deqn{Y_t = (Y_{1t},\dots,Y_{Nt})}{Y_t = (Y_{1t},...,Y_{Nt})}
observed in $N$ distinct cell lineages.
In particular,  the cellular events of duplication, death and differentiation are
respectively coded with the character labels \eqn{\texttt{"A->1"}}{"A->1"}, \eqn{\texttt{"A->0"}}{"A->0"},
and \eqn{\texttt{"A->B"}}{"A->B"}, where  \eqn{\texttt{A}}{A} and  \eqn{\texttt{B}}{B} are two distinct cell types.
The output is a \eqn{3}{3}-dimensional array \eqn{Y}{Y} whose \eqn{ijk}{ijk}-entry \eqn{Y_{ijk}}{Y_{ijk}}
is the number of cells of clone \eqn{k}{k} for cell type \eqn{j}{j} collected at time \eqn{i}{i}.
More mathematical details can be found in the vignette of this package.
}
\examples{
rcts <- c("A->1", "B->1", "C->1", "D->1",
          "A->0", "B->0", "C->0", "D->0",
          "A->B", "A->C", "C->D") ## set of reactions
ctps <- head(LETTERS,4)
nC <- 3 ## number of clones
S <- 10 ## trajectory length
tau <- 1 ## for tau-leaping algorithm
u_1 <- c(.2, .15, .17, .09*5,
         .001, .007, .004, .002,
         .13, .15, .08)
u_2 <- c(.2, .15, .17, .09,
         .001, .007, .004, .002,
         .13, .15, .08)
u_3 <- c(.2, .15, .17*3, .09,
         .001, .007, .004, .002,
         .13, .15, .08)
theta_allcls <- cbind(u_1, u_2, u_3) ## clone-specific parameters
rownames(theta_allcls) <- rcts
s20 <- 1 ## additional noise
Y <- array(data = NA,
           dim = c(S + 1, length(ctps), nC),
           dimnames = list(seq(from = 0, to = S*tau, by = tau),
                           ctps,
                           1:nC)) ## empty array to store simulations
Y0 <- c(100,0,0,0) ## initial state
names(Y0) <- ctps
for (cl in 1:nC) { ## loop over clones
  Y[,,cl] <- get.sim.tl(Yt = Y0,
                        theta = theta_allcls[,cl],
                        S = S,
                        s2 = s20,
                        tau = tau,
                        rct.lst = rcts,
                        verbose = TRUE)
}
Y
}
