% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallRev.R
\name{callRev}
\alias{callRev}
\title{Basic Call to RevBayes}
\usage{
callRev(
  ...,
  coerce = FALSE,
  path = Sys.getenv("rb"),
  viewCode = FALSE,
  use_wd = TRUE,
  knit = FALSE,
  timeout = 5
)
}
\arguments{
\item{...}{character -  input to send to RevBayes.}

\item{coerce}{logical - If TRUE, attempts to coerce output to an R object. If FALSE, output
will remain in String format. Default is FALSE.}

\item{path}{character - Path to the RevBayes executable. Default is Sys.getEnv("RevBayesPath"), which is created with initRev().}

\item{viewCode}{logical - If TRUE, the input and output in the temporary file used to interact
with RevBayes will be displayed in the viewing pane. This option may be useful for
diagnosing code errors.}

\item{use_wd}{logical - If TRUE, sets the working directory in the temporary RevBayes session
to the working directory of the active R session. Default is TRUE.}

\item{knit}{logical - Argument used to manage output formatting for knitRev(). This argument
should generally be ignored by the user.}

\item{timeout}{integer - Determines how long the system2() call should wait before timing out (seconds). Default is 5.}
}
\value{
out: character - String formatted output from RevBayes

coercedOut: type varies. R object formatted output from RevBayes. Object type varies according to Rev output (Ex: numeric vector or ape::Phylo object)
}
\description{
Submits input to the RevBayes executable and returns output to R in string format. If coerce = TRUE, the function coerceRev()
will attempt to coerce output to a similar R object.
}
\details{
##NOTE - This function provides very limited interaction with RevBayes, and is
mostly intended to provide basic functionalities for other methods. For
more effective RevBayes calls, use doRev().
}
\examples{
\dontrun{
callRev("2^3")
callRev("2^3", coerce = FALSE, viewcode = TRUE)
}
}
