% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_rf_lp.R
\name{compute_lp-forestry}
\alias{compute_lp-forestry}
\alias{compute_lp}
\title{compute lp distances}
\usage{
compute_lp(object, feature.new, feature, p)
}
\arguments{
\item{object}{A `forestry` object.}

\item{feature.new}{A data frame of testing predictors.}

\item{feature}{A string denoting the dimension for computing lp distances.}

\item{p}{A positive real number determining the norm p-norm used.}
}
\value{
A vector lp distances.
}
\description{
return lp ditances of selected test observations.
}
\examples{

# Set seed for reproductivity
set.seed(292313)

# Use Iris Data
test_idx <- sample(nrow(iris), 11)
x_train <- iris[-test_idx, -1]
y_train <- iris[-test_idx, 1]
x_test <- iris[test_idx, -1]

rf <- forestry(x = x_train, y = y_train)
predict(rf, x_test)

# Compute the l2 distances in the "Petal.Length" dimension
distances_2 <- compute_lp(object = rf,
                          feature.new = x_test,
                          feature = "Petal.Length",
                          p = 2)
}
