% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funts_class.R
\name{funts}
\alias{funts}
\title{Functional Time Series (funts) Class}
\usage{
funts(
  X,
  basisobj,
  argval = NULL,
  method = "data",
  start = 1,
  end = NULL,
  vnames = NULL,
  dnames = NULL,
  tname = NULL
)
}
\arguments{
\item{X}{A matrix, three-dimensional array, or a list of matrix or array objects.
When `method="data"`, it represents the observed curve values at discrete
sampling points or argument values. When `method="coefs"`, `X` specifies the coefficients
corresponding to the basis system defined in 'basisobj'. If `X` is a list, it defines a multivariate FTS,
with each element being a matrix or three-dimensional array object. In matrix objects, rows correspond to argument values,
and columns correspond to the length of the FTS. In three-dimensional array objects, the first and second dimensions correspond
to argument values, and the third dimension to the length of the FTS.}

\item{basisobj}{An object of class `basisfd`, a matrix of empirical basis, or a list of `basisfd` or empirical basis objects.
For empirical basis, rows correspond to basis functions, and columns correspond to grid points.}

\item{argval}{A vector list of length `p` which is a set of argument values
corresponding to the observations in X. Each entry in this list should either
be a numeric value or a list of numeric elements, depending on the dimension of the domain
the variable is observed over. It can even vary from one variable to another,
If it be NULL, the default value for argval are the integers 1 to n, where n
is the size of the first dimension in argument X.?}

\item{method}{Determines the type of the `X` matrix: "coefs" or "data."}

\item{start}{The time of the first observation. It can be a single positive integer or an object of classes `Date`, `POSIXct`, or `POSIXt`,
specifying a natural time unit.}

\item{end}{The time of the last observation, specified in the same way as `start`.}

\item{vnames}{a vector of strings specifies the variable names}

\item{dnames}{list of vector of strings specifies the variable domain names}

\item{tname}{a string specifies the time index name}
}
\value{
An instance of the `funts` class containing functional time series data.

An instance of the `funts` class containing functional time series data.
}
\description{
The `funts` class is designed to encapsulate functional time series objects, including both univariate (FTS) and multivariate (MFTS) forms.
It provides a versatile framework for creating and manipulating `funts` objects, accommodating various basis systems and dimensions.
}
\examples{
# 1D FTS example: Callcenter dataset
require(fda)
Call_data <- loadCallcenterData()
D <- matrix(sqrt(Call_data$calls), nrow = 240)
bs1 <- create.bspline.basis(c(0, 23), 22)
Y <- funts(X = D, basisobj = bs1, start = as.Date("1999-1-1"),
           vnames = "Sqrt of Call Numbers",
           dnames = "Time (6 minutes aggregated)",
           tname = "Date" )

plot(Y, lwd = 2, npts = 200, col = "deepskyblue4",
  main = "Call Center Data"
)

# _______2D Multivariate Example: Montana dataset
# Temperature curves and smoothed images of vegetation
montana_data <- loadMontanaData()
Temp <- montana_data$Temp
NDVI <- montana_data$NDVI
Montana_Data <- list(Temp / sd(Temp), NDVI)
bs1 <- create.bspline.basis(c(0, 23), 11)
bs2 <- create.bspline.basis(c(1, 33), 13)
bs2d <- list(bs2, bs2)
bsmv <- list(bs1, bs2d)
Y <- funts(X = Montana_Data, basisobj = bsmv,
           start = as.Date("2008-01-01"),
           end = as.Date("2013-09-30"),
           vnames = c("Normalized Temperature (\u00B0C)" , "NDVI"),
           dnames = list("Time", c("Latitude", "Longitude")),
           tname = "Date"
)

plot(Y,  main = "Montana dataset")

}
\seealso{
\code{\link{fssa}}
}
