% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_file.R
\name{get_file}
\alias{get_file}
\title{GET file}
\usage{
get_file(
  file_key,
  version = NULL,
  ids = NULL,
  depth = NULL,
  geometry = NULL,
  plugin_data = NULL,
  branch_data = NULL
)
}
\arguments{
\item{file_key}{string. The key that a Figma file is referred by.}

\item{version}{string. A certain version ID to obtain. By omitting this,
you'll obtain the file's most recent version.}

\item{ids}{string. list the document's nodes that are important to you,
separated by commas. If supplied, only the nodes listed, their children,
and everything between the root node and the listed nodes will be returned
as part of the document.}

\item{depth}{integer. A positive number indicating the depth of the
traversal across the document tree. For instance, changing this to 2
returns both Pages and all top level objects on each page instead of just
returning Pages. All nodes are returned if this argument is not set.}

\item{geometry}{string. To export vector data, set equal to "paths".}

\item{plugin_data}{string. A list of plugin IDs separated by commas or the
word "shared." The result's 'pluginData' and 'sharedPluginData' attributes
will contain any data existing in the document created by those plugins.}

\item{branch_data}{boolean. The requested file's branch metadata is returned.
If the file is a branch, the returned response will also provide the key for
the main file. If the file has branches, the response will also contain the
metadata for those branches. Standard: false.}
}
\value{
S3 object of class \code{figma_file_resp}. Contains the parsed content,
the path, and the API response compatible with \code{httr2} methods. The
retrieved file's metadata includes the \code{name}, \code{lastModified},
\code{thumbnailUrl}, \code{editorType}, \code{linkAccess}, and \verb{version attributes}. A Node
with the DOCUMENT type is present in the document attribute.
}
\description{
Direct access to the desired  file is made available using
the GET file API endpoint. It returns a JSON object representing the file
pointed to by:key. Any Figma file url, such as
https://www.figma.com/file/:key/:title, can be used to parse the file key.
}
\examples{
\dontshow{if (Sys.getenv("FIGMA_ACCESS_TOKEN") != "") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
#navigate to  file and get key from url
file_key <- "sFHgQh9dL6369o5wrZHmdR"
get_file(file_key)
}
\dontshow{\}) # examplesIf}
}
