% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_mixed.R
\name{estimate_mixed}
\alias{estimate_mixed}
\alias{model_mixed_eap}
\alias{model_mixed_map}
\title{Estimation of the Mixed Format Model}
\usage{
model_mixed_eap(u, items, D = 1.702, priors = c(0, 1),
  bounds_t = c(-4, 4))

model_mixed_map(u, items, D = 1.702, priors = c(0, 1),
  bounds_t = c(-4, 4), iter = 30, conv = 0.001)
}
\arguments{
\item{u}{the response data, 2d marix}

\item{items}{a list of 3pl, gpcm, grm items}

\item{D}{the scaling constant}

\item{priors}{the prior distribution}

\item{bounds_t}{the lower- and upper-bound of the parameter}

\item{iter}{the maximum number of newton-raphson iterations}

\item{conv}{the convergence criterion}
}
\value{
\code{model_mixed_eap} returns a list of point estimates and
standard error of the ability parameters

\code{model_mixed_map} returns a list of point estimates of the ability parameters
}
\description{
Estimate the mixed format model
}
\examples{
x <- model_mixed_gendata(200, 30, 5, 5, 3)
y <- model_mixed_eap(x$u, x$items)
c('corr'=cor(x$t, y$t), 'rmse'=rmse(x$t, y$t))
x <- model_mixed_gendata(200, 30, 5, 5, 3)
y <- model_mixed_map(x$u, x$items)
c('corr'=cor(x$t, y$t), 'rmse'=rmse(x$t, y$t))
}
