% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inOAuth.R
\name{inOAuth}
\alias{inOAuth}
\title{Create OAuth token to LinkedIn R session}
\usage{
inOAuth(application_name = NULL, consumer_key = NULL,
  consumer_secret = NULL)
}
\arguments{
\item{application_name}{Name of your application.}

\item{consumer_key}{Consumer API Key of your application.}

\item{consumer_secret}{Consumer Secret Key of your application.}
}
\value{
Authorization token to be used in other functions.
}
\description{
\code{inOAuth} creates a long-lived OAuth access token that enables R to make
authenticated calls to the LinkedIn API. This function relies on the
\code{httr} package to create the OAuth token.
}
\details{
There are two ways to create an authenticated connection.  One is to use 
the default credentials supplied in the package.  The second is to obtain
your own credentials and using them as inputs into the function.
Examples of both are shown below. 

Create your own application here: \url{https://developer.linkedin.com/}
}
\examples{
\dontrun{

## Default Consumer and Secret Key for the Rlinkedin package:
in.auth <- inOAuth()

## Use your own Consumer and Secret Key:
in.auth <- inOAuth("your_app_name", "your_consumer_key", "your_consumer_secret")
}
}
\author{
Michael Piccirilli \email{michael.r.piccirilli@gmail.com}
}
\seealso{
\code{\link{getProfile}}, \code{\link{getMyConnections}}
}

