% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ngrams.R
\name{token_ngrams}
\alias{token_ngrams}
\title{N-gram tokenizer based on mecab-ko}
\usage{
token_ngrams(phrase, n = 3L, div = c("morph", "words", "nouns"),
  stopwords = character(), ngram_delim = " ")
}
\arguments{
\item{phrase}{A character vector or a list of character vectors to be tokenized into morphemes.
If \code{phrase} is a charactor vector, it can be of any length, and each element
will be tokenized separately. If \code{phrase} is a list of charactor vectors, each element
of the list should be a one-item vector.}

\item{n}{The number of words in the n-gram. This must be an integer greater than or equal to 1.}

\item{div}{The token generator definition. The options are "morph", "words", and "nouns".}

\item{stopwords}{Stopwords set to exclude tokens.}

\item{ngram_delim}{The separator between words in an n-gram.}
}
\value{
A list of character vectors containing the tokens, with one element in the list.

See examples in \href{https://github.com/junhewk/RmecabKo}{Github}.
}
\description{
This function tokenizes inputs into n-grams. For the developmental purpose, this function offers
basic n-gram (or shingle n-gram) only. Other n-gram functionality will be added later. Punctuations
and numerics are stripped for this tokenizer, because in Korean n-grams those are usually useless.
N-gram function is based on the selective morpheme tokenizer (\code{token_words}), but you can
select other tokenizer as well.
}
\examples{
\dontrun{
txt <- # Some Korean sentence

token_ngrams(txt)
token_ngrams(txt, n = 2)
}

}
