% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05-harmonized_data_visualize.R
\name{harmonized_dossier_visualize}
\alias{harmonized_dossier_visualize}
\title{Generate a web-based visual report for a harmonized dossier}
\usage{
harmonized_dossier_visualize(
  harmonized_dossier,
  bookdown_path,
  harmonized_dossier_summary = NULL
)
}
\arguments{
\item{harmonized_dossier}{A list containing the harmonized dataset(s).}

\item{bookdown_path}{A character string identifying the folder path where
the bookdown report files will be saved.}

\item{harmonized_dossier_summary}{A list which identifies an existing
summary produced by \code{\link[=harmonized_dossier_summarize]{harmonized_dossier_summarize()}} of the harmonized
variables.
Using this parameter can save time in generating the visual report.}
}
\value{
A folder containing files for the bookdown document. To open the bookdown document
in a browser, open 'docs/index.html', or use \code{\link[=bookdown_open]{bookdown_open()}} with the
folder path.
}
\description{
Generates a visual report of a harmonized dossier in an HTML bookdown
document, with summary figures and statistics for each harmonized variable.
The report outputs can be grouped by a categorical variable.
}
\details{
A harmonized dossier is a named list containing one or more data frames,
which are harmonized datasets. A harmonized dossier is generally the
product of applying processing to a dossier object. The name of each
harmonized dataset (data frame) is taken from the reference input dataset.
A harmonized dossier also contains the DataSchema and
Data Processing Elements used in processing as attributes.
}
\examples{
\donttest{

library(fs)

# Use Rmonize_examples to run examples.
# Perform data processing

harmonized_dossier <- Rmonize_examples$`harmonized_dossier`
harmonized_dossier_summary <- Rmonize_examples$`summary_report_harmonized_dossier`

# Create a folder where the visual report will be placed

if(dir_exists(tempdir())) dir_delete(tempdir())
bookdown_path <- tempdir()

# Generate the visual report
harmonized_dossier_visualize(
  harmonized_dossier = harmonized_dossier,
  bookdown_path = bookdown_path,
  harmonized_dossier_summary = harmonized_dossier_summary)
  
# To open the file in a browser, open 'bookdown_path/docs/index.html'.
# Or use bookdown_open(bookdown_path) function.

}

}
\seealso{
\code{\link[=dataset_visualize]{dataset_visualize()}}
\code{\link[=bookdown_open]{bookdown_open()}}
}
