% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RobPC.R
\name{RobPC}
\alias{RobPC}
\title{Robust Panel Clustering Algorithm}
\usage{
RobPC(data, k, robclust = FALSE, trim = 0.25)
}
\arguments{
\item{data}{the panel data. It must be array.}

\item{k}{the number of clusters.}

\item{robclust}{a logical arguments. If robclust=TRUE, the function implements the robust panel clustering analysis. Otherwise, it implements the traditional panel clustering analysis. The default value is robclust=TRUE.}

\item{trim}{numeric between 0 and 1. Proportion of points to be trimmed. The default value is 0.25.}
}
\value{
a list with 2 elements:
\item{clusters}{integer vector coding cluster membership. If robclust=TRUE, this vector includes codes as k+1 to define outliers clusters.}
\item{clustering_method}{The used clustering method which is "Robust Panel Clustering" or "Panel Clustering".}
}
\description{
Robust Panel Clustering Algorithm
}
\details{
\code{RobPC} function implements the traditional or robust panel clustering analysis without being affected by outliers in the panel data.
}
\examples{

 set.seed(123)
 n_obs <- 10  # Number of observations (N)
 n_time <- 5   # Number of time periods (T)
 n_vars <- 3   # Number of variables (D)
 
 data <- array(rnorm(n_obs * n_time * n_vars), dim = c(n_obs, n_time, n_vars))

 # Apply the Classical Panel Clustering
 
    result_classic <- RobPC(data,k=3,robclust = FALSE)
    result_classic
    
 # Apply the Robust Panel Clustering
 
    result_robust<- RobPC(data,k=3,robclust = TRUE,trim=0.2)
    result_robust
}
\references{
Bulut et al. (Unpublished). A Robust Clustering Algorithms for Panel Data.

Wang, W., & Lu, Y. (2021). Application of clustering analysis of panel data in economic and social research based on R software. Acad. J. Bus. Manag, 3, 98-104.

Cuesta-Albertos, J. A., Gordaliza, A., & Matrán, C. (1997). Trimmed k-means: an attempt to robustify quantizers. The Annals of Statistics, 25(2), 553-576.
}
\author{
Hasan BULUT <hasan.bulut@omu.edu.tr>
}
