% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFPE.R
\name{drop1.lmrobdetMM}
\alias{drop1.lmrobdetMM}
\title{RFPE of submodels of an \code{\link{lmrobdetMM}} fit}
\usage{
\method{drop1}{lmrobdetMM}(object, scope, scale, keep, ...)
}
\arguments{
\item{object}{the \code{MM} element (of class \code{lmrob}) in an object of class \code{\link{lmrobdetMM}}.}

\item{scope}{an optional \code{formula} giving the terms to be considered for dropping. Typically 
this argument is omitted, in which case all possible terms are dropped (without breaking hierarchy 
rules). The \code{scope} can also be a character vector of term labels. If the argument is supplied as a 
formula, any \code{.} is interpreted relative to the formula implied by the \code{object} argument.}

\item{scale}{an optional residual scale estimate. If missing the residual
scale estimate in \code{object} is used.}

\item{keep}{a character vector of names of components that should be saved for each subset model. 
Only names from the set \code{"coefficients"}, \code{"fitted"} and \code{"residuals"}
are allowed. If \code{keep == TRUE}, the complete set is saved. The default behavior is 
not to keep anything.}

\item{\dots}{additional parameters to match generic method \code{drop1}}
}
\value{
An anova object consisting of the term labels, the degrees of freedom, and Robust Final 
Prediction Errors (RFPE) for each subset model. If \code{keep} is missing, the anova object is 
returned. If \code{keep} is present, a list with components \code{"anova"} and \code{"keep"} is returned. 
In this case, the \code{"keep"} component is a matrix of mode \code{"list"}, with a column for each 
subset model, and a row for each component kept.
}
\description{
This function computes the RFPE for the MM-estimators obtained with \code{\link{lmrobdetMM}} by
recomputing it, successively removing each of a number of specified terms. 
It is used internally by \code{\link{step.lmrobdetMM}} and not meant to be used
directly.
}
\references{
\url{http://www.wiley.com/go/maronna/robust}
}
\seealso{
\code{\link{lmrobdetMM}}
}
\author{
Victor Yohai, \email{victoryohai@gmail.com},  Matias Salibian-Barrera, \email{matias@stat.ubc.ca}
}
