% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prcompRob.R
\name{prcompRob}
\alias{prcompRob}
\title{Robust Principal Components Cont'd}
\usage{
prcompRob(x, rank. = NULL, delta.scale = 0.5, max.iter = 100L)
}
\arguments{
\item{x}{data matrix with observations in rows}

\item{rank.}{Maximal number of principal components to be used (optional)}

\item{delta.scale}{"delta" parametor of the scale M-estimator (default = 0.5)}

\item{max.iter}{maximum number of iterations (default = 100)}
}
\value{
\item{sdev}{the standard deviation of the principal components}
\item{rotation}{matrix containing the factor loadings}
\item{x}{matrix containing the rotated data}
\item{center}{the centering used}
}
\description{
This function uses the pcaRobS function to compute all principal components while
behaving similarly to the prcomp function
}
\examples{
data(wine)

p.wine <- prcompRob(wine)
summary(p.wine)

## Choose only 5
p5.wine <- prcompRob(wine, rank. = 5)
summary(p5.wine)

}
\author{
Gregory Brownson, \email{gregory.brownson@gmail.com}
}
