% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_cov_adj.R
\name{get_lm_results}
\alias{get_lm_results}
\alias{h_get_lm_results}
\alias{h_get_strat_lm_results}
\title{Calculate Coefficient Estimates and Corresponding Residuals from Linear Model Input}
\usage{
h_get_lm_results(lm_input)

h_get_strat_lm_results(strat_lm_input)
}
\arguments{
\item{lm_input}{(\code{list}) A list containing the linear model input data for each treatment arm, as returned by
\code{\link[=h_get_lm_input]{h_get_lm_input()}}.}

\item{strat_lm_input}{(\code{list}) A list containing the linear model input data
for each treatment arm and including the \code{.strata} column in the design matrix,
as returned by \code{\link[=h_get_strat_lm_input]{h_get_strat_lm_input()}}.}
}
\value{
A list with:
\itemize{
\item \code{beta_est}: the coefficient estimates for each treatment arm.
\item \code{residuals}: the corresponding residuals for each treatment arm.
}
}
\description{
Calculate the coefficient estimates for each treatment arm from the linear model input data.
Also returns the corresponding residuals.
}
\section{Functions}{
\itemize{
\item \code{h_get_lm_results()}: Calculate the coefficient estimates for the overall data set.

\item \code{h_get_strat_lm_results()}: Calculate the coefficient estimates using the stratified input.

}}
\keyword{internal}
