% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/point_estimates.R
\name{point_estimates}
\alias{point_estimates}
\title{Compute point estimates}
\usage{
point_estimates(x, FUN = mean)
}
\arguments{
\item{x}{An object of class \code{\link{RprobitB_fit}}.}

\item{FUN}{A function that computes a single numeric value out of a vector of numeric
values.}
}
\value{
An object of class \code{\link{RprobitB_parameter}}.
}
\description{
This function computes the point estimates of an \code{\link{RprobitB_fit}}.
Per default, the \code{mean} of the Gibbs samples is used as a point estimate.
However, any statistic that computes a single numeric value out of a vector of
Gibbs samples can be specified for \code{FUN}.
}
\examples{
data <- simulate_choices(form = choice ~ covariate, N = 10, T = 10, J = 2)
model <- fit_model(data)
point_estimates(model)
point_estimates(model, FUN = median)

}
