% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{update_classes_dp}
\alias{update_classes_dp}
\title{Dirichlet process class updates}
\usage{
update_classes_dp(
  beta,
  z,
  b,
  Omega,
  delta,
  mu_b_0,
  Sigma_b_0,
  n_Omega_0,
  V_Omega_0,
  identify_classes = FALSE,
  Cmax = 10L
)
}
\arguments{
\item{beta}{[\code{matrix(nrow = P_r, ncol = N)}]\cr
The matrix of the decider-specific coefficient vectors.}

\item{z}{[\code{numeric(N)}]\cr
The decider class allocations.}

\item{b}{[\code{matrix(nrow = P_r, ncol = C)}]\cr
The matrix of class means as columns.}

\item{Omega}{[\code{matrix(nrow = P_r * P_r, ncol = C)}]\cr
The matrix of vectorized class covariance matrices as columns.}

\item{delta}{[\code{numeric(1)}]\cr
The prior concentration for \code{s}.}

\item{mu_b_0}{[\code{numeric(P_r)}]\cr
The mean vector of the normal prior for each \code{b_c}.}

\item{Sigma_b_0}{[\code{matrix(P_r, P_r)}]\cr
The covariance matrix of the normal prior for each \code{b_c}.}

\item{n_Omega_0}{[\code{integer(1)}]\cr
The degrees of freedom of the Inverse Wishart prior for each \code{Omega_c}.}

\item{V_Omega_0}{[\code{matrix(P_r, P_r)}]\cr
The scale matrix of the Inverse Wishart prior for each \code{Omega_c}.}

\item{identify_classes}{[\code{logical(1)}]\cr
Identify classes by decreasing class weights?}

\item{Cmax}{[\code{integer(1)}]\cr
The maximum number of classes, used to allocate space.}
}
\value{
A list of updated values for \code{z}, \code{b}, \code{Omega}, and \code{C}.
}
\description{
Dirichlet process class updates
}
\examples{
set.seed(1)
z <- c(rep(1, 10),rep(2, 10))
b <- matrix(c(5, 5, 5, -5), ncol = 2)
Omega <- matrix(c(1, 0.3, 0.3, 0.5, 1, -0.3, -0.3, 0.8), ncol = 2)
beta <- sapply(
  z, function(z) oeli::rmvnorm(n = 1, b[, z], matrix(Omega[, z], 2, 2))
)
beta[, 1] <- c(-10, 10)
update_classes_dp(
  beta = beta, z = z, b = b, Omega = Omega,
  delta = 1, mu_b_0 = numeric(2), Sigma_b_0 = diag(2),
  n_Omega_0 = 4, V_Omega_0 = diag(2)
)

}
\keyword{gibbs_sampler}
