% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rprofet.R
\name{Var_select}
\alias{Var_select}
\title{Select variables or filter variables by information value}
\usage{
Var_select(object, id, target, varcol, IVfilter)
}
\arguments{
\item{object}{WOEProfet object.}

\item{id}{ID variable.}

\item{target}{A binary target variable.}

\item{varcol}{Vector of variables to be selected or removed. Character or numeric.}

\item{IVfilter}{Threshold of variables' Information Value.}
}
\value{
A list with the following components.
\item{Bin}{Dataframe with ID, Target, and selected binned variables.}
\item{WOE}{Dataframe with ID, Target, and WOE values for selected binned variables.}
\item{IV}{Information value of the selected binned variables.}
\item{vars}{List containing a dataframe for each variable that consists of Bin, WOE, Target Rate, and observation count.}
}
\description{
Function that selects specified variables or filters variables based on information value for WOEProfet object or WOE_StepAIC object.
}
\examples{
mydata <- ISLR::Default
mydata$ID = seq(1:nrow(mydata)) ## make the ID variable
mydata$default<-ifelse(mydata$default=="Yes",1,0) ## Creating numeric binary target variable
binned <- BinProfet(mydata, id= "ID", target= "default", num.bins = 5) ## Binning variables
WOE_dat <- WOEProfet(binned, "ID", "default", 3:5) ## WOEProfet object
WOE_dat$IV #IV item, the row index will be used for filtering variables
# To remove the income variable from the WOEProfet object
## Select the first two variables based on the IV item
subWOE1 <- Var_select(WOE_dat, id= "ID", target= "default", varcol= c(1,2))
##  Or remove the third variable based on the IV item
subWOE2 <- Var_select(WOE_dat, id= "ID", target= "default", varcol= -3)
## Filter the WOEProfet object based on variables' information values
subWOE3 <- Var_select(WOE_dat, id= "ID", target= "default", IVfilter = 0.05)
}
