% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rsconctdply.R
\name{rsconctdply}
\alias{rsconctdply}
\title{Deploys Multiple Shiny Apps using Configuration File}
\usage{
rsconctdply(filedir)
}
\arguments{
\item{rsconctdply}{Name of the function}
\item{filedir}{Web or local directory path for json file}

}
\description{
Deploys multiple apps (App1, App2,...AppN) to multiple user accounts and server locations on JSON file.
}
\examples{

\dontrun{

#Files on Web
rsconctdply("https://api.myjson.com/bins/o8k2s")

#Files available locally
rsconctdply("~/rconnect_dir.json")

Json file Format:
sample file name with structure: "rconnect_dir.json"

{
  "App1": {
    "Server_url": "https://example1.com:443",
    "Server_NAME": "example1",
    "account": "user1",
    "appDir": "~/location1/"
  },
  "App2": {
    "Server_url": "https://example2.com:123",
    "Server_NAME": "example2",
    "account": "user2",
    "appDir": "~/location2/"
  }
}
}
}
