% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vs_search_exact.R
\name{vs_search_exact}
\alias{vs_search_exact}
\alias{search_exact}
\title{Search for exact full-length matches}
\usage{
vs_search_exact(
  fastx_input,
  database,
  userout = NULL,
  otutabout = NULL,
  userfields = "query+target+id+alnlen+mism+opens+qlo+qhi+tlo+thi+evalue+bits",
  strand = "plus",
  threads = 1,
  vsearch_options = NULL,
  tmpdir = NULL
)
}
\arguments{
\item{fastx_input}{(Required). A FASTA/FASTQ file path or FASTA/FASTQ tibble
object containing the query sequences. See \emph{Details}.}

\item{database}{(Required). A FASTA/FASTQ file path or FASTA/FASTQ tibble
object containing the target sequences.}

\item{userout}{(Optional). A character string specifying the name of the
output file for the alignment results. If \code{NULL} (default), no output is
written to a file and the results are returned as a tibble with the columns
specified in \code{userfields}. See \emph{Details}.}

\item{otutabout}{(Optional). A character string specifying the name of the
output file in an OTU table format. If \code{NULL} (default), no output is
written to a file. If \code{TRUE}, the output is returned as a tibble. See
\emph{Details}.}

\item{userfields}{(Optional). Fields to include in the output file. Defaults
to \code{"query+target+id+alnlen+mism+opens+qlo+qhi+tlo+thi+evalue+bits"}.
See \emph{Details}.}

\item{strand}{(Optional). Specifies which strand to consider when comparing
sequences. Can be either \code{"plus"} (default) or \code{"both"}.}

\item{threads}{(Optional). Number of computational threads to be used by
\code{VSEARCH}. Defaults to \code{1}.}

\item{vsearch_options}{(Optional). A character string of additional arguments
to pass to \code{VSEARCH}. Defaults to \code{NULL}. See \emph{Details}.}

\item{tmpdir}{(Optional). Path to the directory where temporary files should
be written when tables are used as input or output. Defaults to
\code{NULL}, which resolves to the session-specific temporary directory
(\code{tempdir()}).}
}
\value{
A tibble or \code{NULL}.

If \code{userout} is \code{NULL} a tibble containing the alignment results
with the fields specified by \code{userfields} is returned. If \code{userout}
is specified the alignment results are written to the
specified file, and no tibble is returned.

If \code{otutabout} is \code{TRUE}, an OTU table is returned as a tibble.
If \code{otutabout} is a character string, the output is written to the file,
and no tibble is returned.

If neither \code{userout} nor \code{otutabout} is specified, a tibble
containing the alignment results is returned.
}
\description{
\code{vs_search_exact} searches for exact full-length matches of
query sequences in a database of target sequences using \code{VSEARCH}.
}
\details{
Identifies exact full-length matches between query and target sequences
using \code{VSEARCH}. Only 100% identical matches are reported, ensuring high
specificity and making this command much faster than
\code{\link{vs_usearch_global}}.

\code{fastx_input} and \code{database} can either be file paths to a
FASTA/FASTQ files or FASTA/FASTQ objects. FASTA objects are tibbles that
contain the columns \code{Header} and \code{Sequence}, see
\code{\link[microseq]{readFasta}}. FASTQ objects are tibbles that contain the
columns \code{Header}, \code{Sequence}, and \code{Quality}, see
\code{\link[microseq]{readFastq}}.

\code{userfields} specifies the fields to include in the output file. Fields
must be given as a character string separated by \code{"+"}. The default
value of \code{userfields} equals
\code{"query+target+id+alnlen+mism+opens+qlo+qhi+tlo+thi+evalue+bits"}, which
gives a blast-like tab-separated format of twelve fields. See the
'Userfields' section in the \code{VSEARCH} manual for more information.

\code{otutabout} gives the option to output the results in an OTU
table format with tab-separated columns. When writing to a file, the first
line starts with the string "#OTU ID", followed by a tab-separated list of
all sample identifiers (formatted as "sample=X"). Each subsequent line,
corresponding to an OTU, begins with the OTU identifier and is followed by
tab-separated abundances for that OTU in each sample. If \code{otutabout} is
a character string, the output is written to the specified file. If
\code{otutabout} is \code{TRUE}, the function returns the OTU table as a
tibble, where the first column is named \code{otu_id} instead of "#OTU ID".

\code{vsearch_options} allows users to pass additional command-line arguments
to \code{VSEARCH} that are not directly supported by this function. Refer to
the \code{VSEARCH} manual for more details.
}
\examples{
\dontrun{
# You would typically use something else as database
query_file <- file.path(file.path(path.package("Rsearch"), "extdata"),
                        "small.fasta")
db <- query_file

# Search for exact full-length matches with default parameters, with file as output
vs_search_exact(fastx_input = query_file,
                database = db,
                userout = "delete_me.txt")

# Read results, and give column names
result.tbl <- read.table("delete_me.txt",
                         sep = "\t",
                         header = FALSE,
                         col.names = c("query", "target", "id", "alnlen",
                                       "mism", "opens", "qlo", "qhi",
                                       "tlo", "thi", "evalue", "bits"))
}

}
\references{
\url{https://github.com/torognes/vsearch}
}
\seealso{
\code{\link{vs_usearch_global}}
}
