% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gini_RSV.R
\name{gini_RSV}
\alias{gini_RSV}
\title{The Gini coefficient adjusted for negative attributes (Raffinetti, Siletti,
& Vernizzi, 2015)}
\usage{
gini_RSV(y)
}
\arguments{
\item{y}{a vector of attributes containing even negative elements}
}
\value{
The value of the Gini coefficient adjusted for negative attributes.
}
\description{
Computes the Gini coefficient adjusted for negative (even weighted) data.
}
\section{NOTE}{

It produces a conventional Gini coefficient (G)
(Ultsch and Lötsch 2017) if all output values are positive, or
a normalized Gini coefficient (G*) (Raffinetti et al. 2015) if
negative values are produced due to corrected frequencies
(if \code{res.fq = TRUE} or
\code{diff.fq = TRUE}). For more details see
Raffinetti et al. (2015).
}

\examples{
\donttest{
data(nuc_cp)
N = 10 #for the example, we recommend 1e+4 value
n = 15
# Maximizing congruence
NPc_PACo <- max_cong(np_matrix, NUCtr, CPtr, n, N, method = "paco",
               symmetric = FALSE, ei.correct = "sqrt.D",
               percentile = 0.01, res.fq = FALSE)
gini_RSV(y = NPc_PACo)
}

}
\references{
Ultsch A., Lötsch J. (2017). A data science based standardized Gini index
as a Lorenz dominance preserving measure of the inequality of distributions.
PLOS ONE. 12:e0181572. \doi{10.1371/journal.pone.0181572}

Raffinetti E., Siletti E., Vernizzi A. (2015). On the Gini coefficient
normalization when attributes with negative values are considered.
Stat Methods Appl. 24:507–521. \doi{10.1007/s10260-014-0293-4}
}
