% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{occurrences}
\alias{occurrences}
\title{Integrated occurrence dataset for three example species}
\format{
A data frame where each row represents a georeferenced occurrence
record for one of the three species.

Columns correspond to the standardized output of
\code{format_columns()}, including:
\itemize{
\item \code{species}: Cleaned binomial species name
\item \code{decimalLongitude}, \code{decimalLatitude}: Coordinates
\item \code{year}: Year of collection/observation
\item Various taxonomic, temporal, locality, and metadata fields
\item Source identifiers added by \code{format_columns()} (e.g., \code{data_source})
}
}
\usage{
occurrences
}
\description{
A harmonized, multi-source occurrence dataset containing cleaned
georeferenced records for three species:
\itemize{
\item \emph{Araucaria angustifolia} (Parana pine)
\item \emph{Cyanocorax caeruleus} (Azure jay)
\item \emph{Handroanthus serratifolius} (Yellow trumpet tree)
}

Records were retrieved from \strong{GBIF}, \strong{speciesLink}, \strong{BIEN}, and
\strong{iDigBio}, standardized through the package workflow, merged, and
cleaned to remove duplicates.
}
\examples{
# Show the first rows
head(occurrences)

# Number of occurrences per species
table(occurrences$species)

}
\seealso{
\code{format_columns()}, \code{bind_here()}, \code{flag_duplicates()}, \code{remove_flagged()}
}
\keyword{datasets}
