% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{prepared_metadata}
\alias{prepared_metadata}
\title{Metadata templates used internally by \code{format_columns()}}
\format{
A named list of four data frames:
\itemize{
\item \strong{\verb{$gbif}} — template for GBIF dataset.
\item \strong{\verb{$specieslink}} — template for SpeciesLink dataset.
\item \strong{\verb{$idigbio}} — template for iDigBio dataset.
\item \strong{\verb{$bien}} — template for BIEN dataset.
}
}
\usage{
prepared_metadata
}
\description{
A named list of data frames containing metadata templates for the main
biodiversity data providers supported by the package (GBIF, SpeciesLink,
iDigBio, and BIEN).

These templates are used internally by \code{format_columns()} to harmonize
columns.
}
\details{
Each element of \code{prepared_metadata} is a single-row data frame where:
\itemize{
\item \strong{column names} correspond to the package’s standardized output fields
\item \strong{values in the row} represent the original column names used by each
data provider
}

These mappings allow \code{format_columns()} to:
\itemize{
\item rename fields (e.g., \code{scientificname} → \code{scientificName})
\item identify which variables are missing or provider-specific
\item coerce classes consistently (e.g., dates, coordinates)
\item ensure compatibility when combining datasets from different sources
}
}
\examples{
# View template for GBIF records
prepared_metadata$gbif


}
\seealso{
\code{format_columns()}
}
\keyword{datasets}
