% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wcvp_here.R
\name{wcvp_here}
\alias{wcvp_here}
\title{Download distribution data from the World Checklist of Vascular Plants (WCVP)}
\usage{
wcvp_here(
  data_dir,
  overwrite = TRUE,
  remove_files = TRUE,
  timeout = 300,
  verbose = TRUE
)
}
\arguments{
\item{data_dir}{(character) a directory to save the data downloaded from
WCVP.}

\item{overwrite}{(logical) If TRUE, data is overwritten. Default is TRUE.}

\item{remove_files}{(logical) whether to remove the downloaded files used in
building the final dataset. Default is TRUE.}

\item{timeout}{(numeric) maximum time (in seconds) allowed for downloading.
Default is 300. Slower internet connections may require higher values.}

\item{verbose}{(logical) whether to display messages during function
execution. Set to TRUE to enable display, or FALSE to run silently. Default
is TRUE.}
}
\value{
A message indicating that the data were successfully saved in the directory
specified by \code{data_dir}.
}
\description{
This function downloads the World Checklist of Vascular Plants database,
which is required for filtering occurrence records using specialists'
information via the \code{flag_wcvp()} function.
}
\examples{
\donttest{
# Define a directory to save the data
data_dir <- tempdir() # Here, a temporary directory

# Download the WCVP database
wcvp_here(data_dir = data_dir)
}
}
