% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_rules.R
\name{compare_rules}
\alias{compare_rules}
\title{Compare Association Rule Sets and Find Their Intersections}
\usage{
compare_rules(..., display = TRUE, filename = NULL)
}
\arguments{
\item{...}{Named association rule sets (objects of class \code{rules}).}

\item{display}{Logical. If \code{TRUE}, prints the intersection results. Default is \code{TRUE}.}

\item{filename}{Character string. If provided, writes the results to a CSV file. Default is \code{NULL}.}
}
\value{
A list containing the intersections of the provided rule sets.
}
\description{
Compares multiple sets of association rules, identifies intersections,
and optionally displays the results or writes them to a CSV file.
}
\examples{
library(arules)
data(BrookTrout)

# Discretize the BrookTrout dataset
discrete_bt <- dtize_df(BrookTrout, cutoff = "mean")

# Generate the first set of rules with a confidence threshold of 0.5
rules1 <- apriori(
  discrete_bt,
  parameter = list(supp = 0.01, conf = 0.5, target = "rules")
)

# Generate the second set of rules with a higher confidence threshold of 0.6
rules2 <- apriori(
  discrete_bt,
  parameter = list(supp = 0.01, conf = 0.6, target = "rules")
)

# Compare the two sets of rules and display the intersections
compare_rules(
  r1 = rules1,
  r2 = rules2,
  display = TRUE
)

# If `filename = "intersections.csv"`, the data is saved in a .csv file

}
