#' @importFrom stats approx

lambda.interp <- function(lambda, s) {
  # LAMBDA IS THE INDEX SEQUENCE THAT IS PRODUCED BY THE MODEL;
  # S IS THE NEW VECTOR AT WHICH EVALUATIONS ARE REQUIRED.
  # THE VALUE IS A VECTOR OF LEFT AND RIGHT INDICES, AND A VECTOR OF FRACTIONS.
  # THE NEW VALUES ARE INTERPOLATED BEWTEEN THE TWO USING THE FRACTION
  # NOTE: LAMBDA DECREASES. YOU TAKE: SFRAC*LEFT+(1-SFRAC)*RIGHT
  if (length(lambda) == 1) {
    nums <- length(s)
    left <- rep(1, nums)
    right <- left
    sfrac <- rep(1, nums)
  } else {
    s[s > max(lambda)] <- max(lambda)
    s[s < min(lambda)] <- min(lambda)
    k <- length(lambda)
    sfrac <- (lambda[1] - s)/(lambda[1] - lambda[k])
    lambda <- (lambda[1] - lambda)/(lambda[1] - lambda[k])
    coord <- approx(lambda, seq(lambda), sfrac)$y
    left <- floor(coord)
    right <- ceiling(coord)
    sfrac <- (sfrac - lambda[right])/(lambda[left] - lambda[right])
    sfrac[left == right] <- 1
  }
  list(left = left, right = right, frac = sfrac)
}