% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{coef.safe}
\alias{coef.safe}
\title{Extract Model Coefficients from a `safe` Object}
\usage{
\method{coef}{safe}(object, s = NULL, ...)
}
\arguments{
\item{object}{Fitted `safe()` object.}

\item{s}{Values of the penalty parameter `lambda` for which coefficients are requested.
Defaults to the entire sequence used during the model fit.}

\item{...}{Not used.}
}
\value{
Returns a matrix or vector of coefficients corresponding to the specified `lambda` values.
}
\description{
Retrieves the coefficients at specified values of `lambda` from a fitted `safe()` model.
}
\details{
This function extracts coefficients for specified `lambda` values from a `safe()` object.
If `s`, the vector of `lambda` values, contains values not originally used in the model fitting,
the `coef` function employs linear interpolation between the closest `lambda` values from the 
original sequence to estimate coefficients at the new `lambda` values.
}
\examples{
set.seed(1)
n <- 100
p <- 5
x <- matrix(rnorm(n * p), nrow = n, ncol = p)
beta_true <- rep(0.1, 5)
gamma_true <- c(rep(1, 3), -1, -1)
mu <- x \%*\% beta_true
k <- rpois(n, lambda = exp(mu))
alpha_val <- 1
theta <- exp(x \%*\% gamma_true) / alpha_val
y <- rgamma(n, shape = alpha_val, scale = theta)
lambda_val <- 1
fit <- safe(x, y, k, 1, ind_p = c(1, 1, 1, 0, 0))
coef(fit)

}
\seealso{
\code{\link{safe}}, \code{\link{predict.safe}}
}
