% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saver_fit.R
\name{saver.fit}
\alias{saver.fit}
\alias{saver.fit.mean}
\alias{saver.fit.null}
\title{Fits SAVER}
\usage{
saver.fit(
  x,
  x.est,
  do.fast,
  ncores,
  sf,
  scale.sf,
  pred.genes,
  pred.cells,
  null.model,
  ngenes = nrow(x),
  ncells = ncol(x),
  gene.names = rownames(x),
  cell.names = colnames(x),
  estimates.only
)

saver.fit.mean(
  x,
  ncores,
  sf,
  scale.sf,
  mu,
  ngenes = nrow(x),
  ncells = ncol(x),
  gene.names = rownames(x),
  cell.names = colnames(x),
  estimates.only
)

saver.fit.null(
  x,
  ncores,
  sf,
  scale.sf,
  ngenes = nrow(x),
  ncells = ncol(x),
  gene.names = rownames(x),
  cell.names = colnames(x),
  estimates.only
)
}
\arguments{
\item{x}{An expression count matrix. The rows correspond to genes and
the columns correspond to cells.}

\item{x.est}{The log-normalized predictor matrix. The rows correspond to
cells and the columns correspond to genes.}

\item{do.fast}{Approximates the prediction step. Default is TRUE.}

\item{ncores}{Number of cores to use. Default is 1.}

\item{sf}{Normalized size factor.}

\item{scale.sf}{Scale of size factor.}

\item{pred.genes}{Index of genes to perform regression prediction.}

\item{pred.cells}{Index of cells to perform regression prediction.}

\item{null.model}{Whether to use mean gene expression as prediction.}

\item{ngenes}{Number of genes.}

\item{ncells}{Number of cells.}

\item{gene.names}{Name of genes.}

\item{cell.names}{Name of cells.}

\item{estimates.only}{Only return SAVER estimates. Default is FALSE.}

\item{mu}{Matrix of prior means.}
}
\value{
A list with the following components
\item{\code{estimate}}{Recovered (normalized) expression}
\item{\code{se}}{Standard error of estimates}
\item{\code{info}}{Information about fit}
}
\description{
Fits SAVER object
}
\details{
The SAVER method starts by estimating the prior mean and variance for the
true expression level for each gene and cell. The prior mean is obtained
through predictions from a Lasso Poisson regression for each gene
implemented using the \code{glmnet} package. Then, the variance is estimated
through maximum likelihood assuming constant variance, Fano factor, or
coefficient of variation variance structure for each gene. The posterior
distribution is calculated and the posterior mean is reported as the SAVER
estimate.
}
