% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custombar.R
\name{custombar}
\alias{custombar}
\title{custombar}
\usage{
custombar(X, iobs, plotname = "", ylabelname = "Contribution", xlabelname = "")
}
\arguments{
\item{X}{matrix with observations as row vectors.}

\item{iobs}{index of the observations whose value will be displayed.}

\item{plotname}{string with the title of the plot. Set to "" by default.}

\item{ylabelname}{string with the y-axis label. Set to "Contribution" by default.}

\item{xlabelname}{string with the y-axis label. Set to "" by default.}
}
\value{
ggplot object with the values of a vector with a customized geom_col layer.
}
\description{
Bar plot with customized title and labels. Y-Axis limits are fixed
according to the range of the values in X.
}
\examples{
X <- as.matrix(X)
custombar(X, 2)
custombar(X, 2, plotname = "Observation 2", ylabelname = bquote(x.["j"]), 
xlabelname= "Variables")
}
