% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_expression.R
\name{comparedeg_scatter}
\alias{comparedeg_scatter}
\title{Generate a scatter plot comparing two differential expression results}
\usage{
comparedeg_scatter(
  results1,
  results2,
  result_names = NULL,
  fc_cutoff,
  pval_cutoff,
  pvalflag = TRUE,
  interactive = FALSE
)
}
\arguments{
\item{results1}{a data.frame containing differential expression results with five columns: "Gene name", "log2 fold change", "log2 average expression",
"p value", "adjusted p value". The second element of the output from function \code{\link{run_de}}.}

\item{results2}{similar to \code{results1}.}

\item{result_names}{a vector of length 2 indicating the names of the two differential results. If NULL, names will be set to c("results1", "results2")}

\item{fc_cutoff}{fold change cutoff to identify differential expressed genes.}

\item{pval_cutoff}{p value cutoff to identify differential expressed genes.}

\item{pvalflag}{a logical value indicating whether to use adjusted p value in selecting differential expressed genes.}

\item{interactive}{a logical value indicating whether to generate an interactive plot.}
}
\value{
a \code{ggplot} object or \code{plotly} object if interactive is set to TRUE
}
\description{
Generate a scatter plot of fold changes comparing two differential expression results, e.g. w/wo adjusting for cell proportion differences.
}
\details{
See examples from \code{\link{run_de}}.
}
