% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiplierBootstrap.R
\name{MultiplierBootstrap}
\alias{MultiplierBootstrap}
\title{Multiplier Bootstrap}
\usage{
MultiplierBootstrap(
  R,
  Q = NULL,
  alpha = 0.05,
  Mboots = 5000,
  method = "t",
  weights = "rademacher"
)
}
\arguments{
\item{R}{Array of shape (..., N), where N is number of repetitions}

\item{Q}{Optional second sample array for two-sample SCB}

\item{alpha}{Significance level (default 0.05)}

\item{Mboots}{Number of bootstrap replications (default 5000)}

\item{method}{Method for SD estimation: "t" or "regular"}

\item{weights}{Multiplier type: "rademacher", "gaussian", or "mammen"}
}
\value{
A list with fields: \code{z} (distribution), \code{q} (threshold), and \code{samples}
}
\description{
Multiplier Bootstrap
}
\examples{
# Used internally by SCB_dense and functional_outcome_scb

}
\references{
Telschow, F. J. E., & Schwartzman, A. (2022).
Simultaneous confidence bands for functional data using the Gaussian Kinematic formula.
\emph{Journal of Statistical Planning and Inference}, 216, 70–94.
\doi{10.1016/j.jspi.2021.05.008}
}
\keyword{internal}
