% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semTools.R
\name{loadPathways}
\alias{loadPathways}
\title{Import pathways and generate a reference network}
\usage{
loadPathways(db, organism = "hsapiens", id_type = "ENTREZID", lcc = TRUE, ...)
}
\arguments{
\item{db}{String indicating the database name. Please, check the 
\code{\link[graphite]{pathways}} function from \pkg{graphite} to list
the available datasets.}

\item{organism}{A string indicating the source organism. Please, check 
the \code{\link[graphite]{pathways}} function from \pkg{graphite} to list
the available datasets (default = "hsapiens")}

\item{id_type}{Gene ID type. The default is set to "ENTREZID" (standard 
SEM fitting nomenclature). A common choice could be "SYMBOL", for 
official gene symbols.}

\item{lcc}{A logical value. If TRUE (default), the reference network 
will only include the largest connected component. It will include all 
disconnected components otherwise.}

\item{...}{Currently ignored.}
}
\value{
A list of 2 objects:
\enumerate{
\item a list of pathways ad igraph objects;
\item the union of graphs in the pathway list.
}
}
\description{
Utility to create pathway lists as igraph objects and 
interaction networks from Reactome, KEGG, and other pathway databases.
}
\details{
This function uses \code{graphite} to download and preprocess 
network data from pathway databases. The output is then created using 
igraph and SEMgraph utilities.
}
\examples{

\dontrun{

# Create KEGG reference pathway list and reference network for Homo sapiens
kegg.hs <- loadPathways("kegg", "hsapiens", "ENTREZID")

# Inspect results
names(kegg.hs$pathways)
kegg.hs$network

}

}
\references{
Sales G, Calura E, Cavalieri D, Romualdi C (2012). graphite - a Bioconductor 
package to convert pathway topology to gene network. 
BMC Bioinformatics. 
<https://bmcbioinformatics.biomedcentral.com/articles/10.1186/1471-2105-13-20>
}
\author{
Fernando Palluzzi \email{fernando.palluzzi@gmail.com}
}
