% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getValue.R
\name{getValue}
\alias{getValue}
\title{Get the value of a specified SEM path parameter after case deletion}
\usage{
getValue(drops_index, df, model, var_one, var_two)
}
\arguments{
\item{drops_index}{Integer vector of observation indices to drop from the data.}

\item{df}{A data frame containing the dataset.}

\item{model}{A lavaan SEM model specification.}

\item{var_one}{Character string giving the dependent (left-hand side) variable.}

\item{var_two}{Character string giving the predictor (right-hand side) variable.}
}
\value{
A numeric scalar giving the parameter estimate for the specified path
after removing the selected observations.
}
\description{
This helper function refits the specified SEM model after dropping
the given cases and extracts the parameter estimate for the specified path
(e.g., \code{var_one ~ var_two}).
}
