% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_to_SEset.R
\name{network_to_SEset}
\alias{network_to_SEset}
\title{SE-set from precision matrix}
\usage{
network_to_SEset(
  omega,
  orderings = NULL,
  digits = 20,
  rm_duplicates = FALSE,
  input_type = "precision"
)
}
\arguments{
\item{omega}{input \eqn{p \times p} precision matrix}

\item{orderings}{An optional matrix of \eqn{n} orderings from which to generate the
SE-set. Must be in the form of a \eqn{p \times n} matrix with each column a vector of
dimension names in the desired order. If unspecified, all \eqn{p!} possible
orderings are used}

\item{digits}{desired rounding of the output weights matrices in the SE-set,
in decimal places. Defaults to 20.}

\item{rm_duplicates}{Logical indicating whether only unique DAGs should be returned}

\item{input_type}{specifies what type of matrix `omega` is.
 default is "precision", other options include a matrix of partial correlations
("parcor") or a model implied covariance or correlation matrix "MIcov"}
}
\value{
a \eqn{p! \times p} matrix containing the SE-set
    (or \eqn{n \times p}  matrix if a custom set of \eqn{n} orderings is specified).
    Each row represents a lower-triangular weights matrix, stacked column-wise.
}
\description{
Takes a precision matrix and generates the SE-set, a set of
    statistically equivalent path models. Unless otherwise specified, the SEset
    will contain one weights matrix for every possible topological ordering of the
   input precision matrix
}
\examples{
# first estimate the precision matrix
data(riskcor)
omega <- (qgraph::EBICglasso(riskcor, n = 69, returnAllResults = TRUE))$optwi
# qgraph method estimates a non-symmetric omega matrix, but uses forceSymmetric to create
# a symmetric matrix (see qgraph:::EBICglassoCore line 65)
omega <- as.matrix(Matrix::forceSymmetric(omega)) # returns the precision matrix

SE <- network_to_SEset(omega, digits=3)

# each row of SE defines a path-model weights matrix.
# We can extract element 20 by writing it to a matrix
example <- matrix(SE[20,],6,6)

# Example path model can be plotted as a weighted DAG
pos <- matrix(c(2,0,-2,-1,-2,1,0,2,0.5,0,0,-2),6,2,byrow=TRUE)

# qgraph reads matrix elements as "from row to column"
# regression weights matrices are read "from column to row"
# path model weights matrix must be transposed for qgraph

qgraph::qgraph(t(example), labels=rownames(riskcor), layout=pos,
repulsion=.8, vsize=c(10,15), theme="colorblind", fade=FALSE)
}
\references{
\insertRef{ryan2019}{SEset}

    \insertRef{shojaie2010penalized}{SEset}

    \insertRef{bollen89sem}{SEset}
}
\seealso{
\code{\link{network_to_path}}, \code{\link{reorder_mat}}, \code{\link{order_gen}}
}
