% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/targetD.R
\name{targetD}
\alias{targetD}
\title{Computation of the diagonal target D ('diagonal, unequal variances').}
\usage{
targetD(x, genegroups)
}
\arguments{
\item{x}{A \eqn{n \times p}{n x p} data matrix.}

\item{genegroups}{The genegroups are not used for this target.}
}
\value{
A \eqn{p \times p}{p x p} diagonal matrix.
}
\description{
The \eqn{p \times p}{n x p} diagonal target D is computed from the \eqn{n
\times p}{n x p} data matrix. It is defined as follows (\eqn{i,j =
1,...,p}{i,j=1,...,p}): 
\deqn{t_{ij}=\begin{cases}s_{ii} & \text{ if } i=j \\ 0 & \text{ otherwise }\end{cases}}
where
\eqn{s_{ij}}{sij} denotes the entry of the unbiased covariance matrix in row
\eqn{i}{i}, column \eqn{j}{j}.
}
\examples{

x <- matrix(rnorm(10*30),10,30)
tar <- targetD(x,NULL)

}
\references{
J. Schaefer and K. Strimmer, 2005. A shrinkage approach to
large-scale covariance matrix estimation and implications for functional
genomics.  Statist. Appl. Genet. Mol. Biol. 4:32.
}
\seealso{
\code{\link{targetCor}}, \code{\link{targetF}},
\code{\link{targetG}}, \code{\link{targetGstar}}, \code{\link{targetGpos}}.
}
\author{
Monika Jelizarow and Vincent Guillemot
}
\keyword{methods}
\keyword{multivariate}
