% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Parameters_Selection.R
\name{BIC_SILFS}
\alias{BIC_SILFS}
\title{Selecting Tuning Parameter for SILFS Method via corresponding BIC}
\usage{
BIC_SILFS(
  Y,
  Fhat,
  Uhat,
  K,
  alpha_init,
  lasso_start,
  lasso_stop,
  CAR_start,
  CAR_stop,
  grid_1,
  grid_2,
  epsilon
)
}
\arguments{
\item{Y}{The response vector of length \eqn{n}.}

\item{Fhat}{The estimated common factors matrix of size \eqn{n \times r}.}

\item{Uhat}{The estimated idiosyncratic factors matrix of size \eqn{n \times p}.}

\item{K}{The estimated subgroup number.}

\item{alpha_init}{The initialization of intercept parameter.}

\item{lasso_start}{The user-supplied start search value of the tuning parameters for LASSO.}

\item{lasso_stop}{The user-supplied stop search value of the tuning parameters for LASSO.}

\item{CAR_start}{The user-supplied start search value of the tuning parameters for Center-Augmented Regularization.}

\item{CAR_stop}{The user-supplied stop search value of the tuning parameters for Center-Augmented Regularization.}

\item{grid_1}{The user-supplied number of search grid points corresponding to the LASSO tuning parameter.}

\item{grid_2}{The user-supplied number of search grid points corresponding to the tuning parameter for Center-Augmented Regularization.}

\item{epsilon}{The user-supplied stopping tolerance.}
}
\value{
A list with the following components:
\item{lasso}{The tuning parameter of the LASSO penalty selected using BIC.}
\item{CAR}{The tuning parameter of the Center Augmented Regularization selected using BIC.}
}
\description{
This function is to select tuning parameters simultaneously for SILFS method via minimizing the BIC.
}
\examples{
n <- 50
p <- 50
r <- 3
K <- 2
lasso_start <- sqrt(log(p)/n)*0.01
lasso_stop <- sqrt(log(p)/n)*10^(0.5)
CAR_start <- 0.001
CAR_stop <- 0.1
grid_1 <- 5
grid_2 <- 5
alpha <- sample(c(-3,3),n,replace=TRUE,prob=c(1/2,1/2))
beta <- c(rep(1,2),rep(0,48))
B <- matrix((rnorm(p*r,1,1)),p,r)
F_1 <- matrix((rnorm(n*r,0,1)),n,r)
U <- matrix(rnorm(p*n,0,0.1),n,p)
X <- F_1\%*\%t(B)+U
Y <- alpha + X\%*\%beta + rnorm(n,0,0.5)
alpha_init <- INIT(Y,F_1,0.1)
\donttest{
BIC_SILFS(Y,F_1,U,K,alpha_init,lasso_start,lasso_stop,CAR_start,CAR_stop,grid_1,grid_2,0.3)
}
}
