% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scr.plot.R
\name{scr.plot}
\alias{scr.plot}
\title{Visualization of simultaneous confidence region (SCR)}
\usage{
scr.plot(scr_df, ops, title = "", lower = -1.3, upper = 1.3)
}
\arguments{
\item{scr_df}{the result of estimation}

\item{ops}{select type of estimation."nfix" refers to no fix estimation. "fixt" indicates fix time t estimation.
"fixx" represents fix variate estimation}

\item{title}{give the title for plot}

\item{lower}{give the lower bound for scale limits, the default is -1.3}

\item{upper}{give the upper bound for scale limits, the default is 1.3}
}
\value{
the plot shows estimated function and its simultaneous confidence region (SCR)
}
\description{
Visualization of simultaneous confidence region (SCR)
}
\examples{
generate_nAR1 = function(n, v){
 ts = c()
 w = rnorm(n, 0, 1/v)
 x_ini = runif(1,0,1)
 for(i in 1:n){
   if(i == 1){
     ts[i] = sin(2*pi*(i/n))*exp(-x_ini^2)  + w[i] #
   } else{
     ts[i] = sin(2*pi*(i/n))*exp(-ts[i-1]^2) + w[i]
   }
 }
 return(ts)
}
ts  = generate_nAR1(27, 1) #change sample size in real case. 
res_esti = fix.SCR(ts, 1, 1, m = "MV", "Legen", "Legen", "algeb", "fixt", 0.6, r = 1)
scr.plot(res_esti[[1]], "fixt")
}
