% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feedback_ml.R
\name{feedback_ml}
\alias{feedback_ml}
\title{Testing for Feedback Effects in a Simultaneous Equation Model}
\usage{
feedback_ml(data, out.decompose, eq.id, lb = -200, ub = 200,
  nrestarts = 10, nsim = 20000, seed.in = 1)
}
\arguments{
\item{data}{the data frame containing the data}

\item{out.decompose}{the decomposition object resulting from \code{causal_decompose()}}

\item{eq.id}{the equation to be tested for feedback effects}

\item{lb}{lower bound of the parameter space required for \code{gosolnp}}

\item{ub}{upper bound of the parameter space required for \code{gosolnp}}

\item{nrestarts}{number of solver restarts (as in \code{gosolnp})}

\item{nsim}{number of random parameters to generate for every restart of the solver (as in \code{gosolnp})}

\item{seed.in}{seed number for gosolnp routine}
}
\value{
A list with components \itemize{
\item \code{rho.est}: a data frame with the maximum likelihood estimate of \eqn{rho} and the
equations with which each element is involved in feedback-like mechanisms
\item \code{loglik}: the value of the log-likelihood of the model
\item \code{theta.hessian}: the hessian matrix for the estimated parameters
\item \code{rho.jacobian}: the Jacobian matrix of \eqn{\rho} with respect to the entire set of parameters
\item \code{wald}: the resulting Wald test statistic
}
}
\description{
Testing for Feedback Effects in a Simultaneous Equation Model
}
\examples{
\donttest{
data("macroIT")
eq.system = list(
              eq1 = C ~  CP  + I + CP_1,
              eq2 = I ~ K + CP_1,
              eq3 = WP ~ I + GDP + GDP_1,
              eq4 = GDP ~ C + I + GDP_1,
              eq5 = CP ~ WP + T,
              eq6 = K ~ I + K_1)

instruments = ~ T + CP_1 + GDP_1 + K_1

c.dec = causal_decompose(data = macroIT,
                         eq.system = eq.system,
                         resid.est = "noDfCor",
                         instruments = instruments)

feedback_ml(data = macroIT,
              out.decompose = c.dec,
              eq.id = 5,
              lb = -200,
              ub = 200,
              nrestarts = 10,
              nsim = 20000,
              seed.in = 1)
}
}
