% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\name{spatialDistribution}
\alias{spatialDistribution}
\title{Quantify the spatial distribution of mutants}
\usage{
spatialDistribution(tumor, N = 500, cutoff = 0.01, make.plot = TRUE)
}
\arguments{
\item{tumor}{A list which is the output of \code{\link{simulateTumor}()}.}

\item{N}{The number of pairs to sample.}

\item{cutoff}{For a plot of clone sizes, all mutations with a MAF below \code{cutoff} are ignored.}

\item{make.plot}{Whether or not to make plots.}
}
\value{
A list with the following components
\itemize{
\item \code{mean_mutant} - A data frame with 2 columns giving the mean number of mutants
as a function of Euclidean distance from the lattice origin (Euclid. distance rounded to nearest integer). 
\item \code{mean_driver} - The same as \code{mean_mutant} except for driver mutations only. Will be \code{NULL} if 
no drivers are present in the simulated tumor. 
\item \code{jaccard} A data frame with two columns giving mean jaccard index as a function of Euclidean distance 
between pairs of cells (rounded to nearest integer). 
}
}
\description{
Provides a summary the spatial distribution of mutants within the simulated
tumor.
}
\details{
The genotype of a cell can be interpreted as a binary vector where the \eqn{i}-th component is 1 if mutation
\eqn{i} is present in the cell and is 0 otherwise. Then a natural comparison of the similarity between two cells is the 
Jaccard index \eqn{J(A,B) = |I(A,B)|/|U(A,B)|}, where \eqn{I(A,B)} is the intersection of \eqn{A} and \eqn{B} and 
\eqn{U(A,B)} is the union. This function estimates the Jaccard index as a function of Euclidean distance between the 
cells by randomly sampling \eqn{N} pairs of cells.
}
\examples{
set.seed(1126490984)
out <- simulateTumor(max_pop = 1000, driver_prob = 0.1)
sp <- spatialDistribution(tumor = out, make.plot = FALSE)

}
\author{
Phillip B. Nicol
}
