% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_AD.R
\encoding{UTF-8}
\name{beta_AD}
\alias{beta_AD}
\title{Caculate the estimators of beta on the A-opt and D-opt}
\usage{
beta_AD(K = K, nk = nk, alpha = alpha, X = X, y = y)
}
\arguments{
\item{K}{is the number of subsets}

\item{nk}{is the length of subsets}

\item{alpha}{is the significance level}

\item{X}{is the observation matrix}

\item{y}{is the response vector}
}
\value{
A list containing:
\item{betaA}{The estimator of beta on the A-opt.}
\item{betaD}{The estimator of beta on the D-opt.}
}
\description{
Caculate the estimators of beta on the A-opt and D-opt
}
\examples{
 p=6;n=1000;K=2;nk=200;alpha=0.05;sigma=1
 e=rnorm(n,0,sigma); beta=c(sort(c(runif(p,0,1))));
 data=c(rnorm(n*p,5,10));X=matrix(data, ncol=p);
 y=X\%*\%beta+e;
 beta_AD(K=K,nk=nk,alpha=alpha,X=X,y=y)
}
\references{
Guo, G., Song, H. & Zhu, L. The COR criterion for optimal subset selection in distributed estimation. \emph{Statistics and Computing}, 34, 163 (2024). \doi{10.1007/s11222-024-10471-z}
}
