% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.smle}
\alias{print.smle}
\alias{print.selection}
\alias{print.summary.smle}
\alias{print.summary.selection}
\alias{print.sdata}
\title{Print an object}
\usage{
\method{print}{smle}(x, ...)

\method{print}{selection}(x, ...)

\method{print}{summary.smle}(x, ...)

\method{print}{summary.selection}(x, ...)

\method{print}{sdata}(x, ...)
}
\arguments{
\item{x}{Fitted object.}

\item{...}{This argument is not used and listed for method consistency.}
}
\value{
Return argument invisibly.
}
\description{
This function prints information about the fitted model from a call to \code{\link{SMLE}()} or \code{\link{smle_select}()},
 or about the simulated data from a call to \code{\link{Gen_Data}()}. The object passed as an argument to print is returned invisibly.
}
\examples{
set.seed(1)
Data<-Gen_Data(correlation = "MA", family = "gaussian")
Data
fit<-SMLE(Y = Data$Y, X = Data$X, k = 20, family = "gaussian")
print(fit)
summary(fit)
}
