% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UnivariateSequentialNormalScores.R
\name{SNS}
\alias{SNS}
\title{Sequential Normal Scores}
\usage{
SNS(
  X,
  X.id,
  Y = NULL,
  theta = NULL,
  Ftheta = NULL,
  scoring = "Z",
  Chi2corrector = "None",
  alignment = "unadjusted",
  constant = NULL,
  absolute = FALSE,
  chart = "Shewhart",
  chart.par = c(3),
  snsRaw = FALSE,
  isFixed = FALSE,
  omit.id = NULL,
  auto.omit.alarm = TRUE
)
}
\arguments{
\item{X}{vector. New observations to obtain the N¡normal scores.}

\item{X.id}{vector. The id of the vector \code{X}.}

\item{Y}{vector. If \code{Y} is not defined (no previous observation available, \code{NULL}), NS is relative to \code{X}. Default \code{NULL}.}

\item{theta}{scalar. Value corresponig with the \code{Ftheta} quantile.}

\item{Ftheta}{scalar. Quantile of the data distribution. The values that take are between (0,1).}

\item{scoring}{character string. If "Z" (normal scores) (default). If "Z-SQ" (normal scores squared).}

\item{Chi2corrector}{character string. Only when scoring is Z-SQ. Select from
\itemize{
  \item{"approx: Z^2*(m + 1 + 1.3)/(m+1).}
  \item{"exact": Z^2/mean(Z).}
  \item{"none": Z^2.}
}
If "approx" () (default). If "exact" (normal scores squared).}

\item{alignment}{character string. Aligment of the data \code{X} and \code{Y}. Select from
\itemize{
  \item "unadjusted": nothing is sustracte from \code{X} and \code{Y} (default).
  \item "overallmean": overall mean is sustracted from \code{X} and \code{Y}.
  \item "overallmedian": overall median is sustracted from \code{X} and \code{Y}.
  \item "samplemean": mean from corresponding group (\code{X} and \code{Y}) is sustracted from its corresponing vector.
  \item "samplemedian": median from corresponding group (\code{X} and \code{Y}) is sustracted from its corresponing vector.
  \item "referencemean": mean from \code{Y} is subtracted from \code{X} and \code{Y}.
  \item "referencemedian": median from \code{Y} is subtracted from \code{X} and \code{Y}.
  \item "constantvalue": a constant value is subtracted from \code{X} and \code{Y}.
}}

\item{constant}{scalar. Only used when the \code{alignment} is selected "constantvalue". Default \code{NULL}.}

\item{absolute}{logical. If \code{TRUE}, the absolute aligned values are obtained. (Default \code{FALSE})}

\item{chart}{character string. Selected type of chart. Three options are available: Shewhart, CUSUM, EWMA}

\item{chart.par}{vector. The size depends on the selected chart:
\describe{
  \item{Shewhart scheme: }{is \code{c(k)}, where \code{k} comes from \eqn{UCL = mu + k\sigma, LCL = mu - k\sigma.}}
  \item{CUSUM scheme: }{is \code{c(k, h, t)} where \code{k} is the reference value and \code{h} is the control limit,
  and \code{t} is the type of the chart (1:positive, 2:negative, 3:two sides)}
  \item{EWMA scheme: }{is \code{c(lambda, L)}, where \code{lambda} is the smoothing constant
  and \code{L} multiplies standard deviation to get the control limit}
}}

\item{snsRaw}{logical. If \code{TRUE} return also the sns for each observation in vector \code{X}.}

\item{isFixed}{logical. If \code{TRUE} the reference sample does not update, otherwise the reference sample is updated whenever the batch is in control.}

\item{omit.id}{vector. Elements of the vector are the id which are omitted in the analysis.}

\item{auto.omit.alarm}{logical. Determine if OC signals are added (or not) to reference sample. By default is set to TRUE.}
}
\value{
Multiple output. Select by \code{output$}
\itemize{
  \item \code{coefficients}: list. Three elements: \code{n} the number of observation per group in \code{X}, \code{chart} the selected chart to perform the analysis, and \code{chart.par} the parameters of the selected chart.
  \item \code{R}: vector. Ranks for the new observations (Monitoring sample).
  \item \code{X}: vector. New observations (Monitoring sample) to obtain the SNS.
  \item \code{Z}: vector. SNS of the \code{X} monitoring sample.
  \item \code{X.id}: vector. The id of each column (variable) of the matrix \code{X}.
  \item \code{UCL}: vector. Upper control limit for each group in \code{X}.
  \item \code{LCL}: vector. Lower control limit for each group in \code{X}.
  \item \code{scoring}: string. Selected score to evaluate SNS.
}
}
\description{
Transform a vector \code{X} into SNS using initial observations \code{Y} if available
SNS follow the order of \code{X}.
}
\section{Comments}{

If ties occur, average ranks are used.
}

\examples{
# EXAMPLE CONDITIONAL WITH REFERENCE SAMPLE
Y <- c(10, 20, 30, 40, 50, 60, 70, 80, 90, 100)
X <- c(30, 35, 45)
theta <- 40
Ftheta <- 0.5
sample.id <- c("a", "b", "c")
SNS(X = X, X.id = sample.id, Y = Y, theta = theta, Ftheta = Ftheta)

# EXAMPLE CONDITIONAL WITH REFERENCE SAMPLE
Y <- c(10, 20, 30, 40, 50, 60, 70, 80, 90, 100)
X <- c(30, 35, 45)
theta <- 40
Ftheta <- 0.5
sample.id <- c("a", "b", "c")
SNS(X = X, X.id = sample.id, Y = Y, theta = theta, Ftheta = Ftheta)

# EXAMPLE UNCONDITIONAL WITH REFERENCE SAMPLE
Y <- c(10, 20, 30, 40, 50, 60, 70, 80, 90, 100)
X <- c(30, 35, 45)
theta <- NULL
Ftheta <- NULL
sample.id <- c("a", "b", "c")
SNS(X = X, X.id = sample.id, Y = Y, theta = theta, Ftheta = Ftheta)

# EXAMPLE CONDITIONAL WITHOUT REFERENCE SAMPLE
Y <- NULL # c(10,20,30,40,50,60,70,80,90,100)
X <- c(30, 35, 45)
theta <- 40
Ftheta <- 0.5
sample.id <- c("a", "b", "c")
SNS(X = X, X.id = sample.id, Y = Y, theta = theta, Ftheta = Ftheta)

# EXAMPLE UNCONDITIONAL WITHOUT REFERENCE SAMPLE
Y <- NULL
X <- c(30, 35, 45)
theta <- NULL
Ftheta <- NULL
sample.id <- c("a", "b", "c")
SNS(X = X, X.id = sample.id, Y = Y, theta = theta, Ftheta = Ftheta)
}
\seealso{
\code{\link{NS}} for normal scores
}
