% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_summary_print_Uni.R
\name{plot.SNSeg_Uni}
\alias{plot.SNSeg_Uni}
\title{Plotting the output for univariate or bivariate time series (testing
the change in correlation between bivariate time series)}
\usage{
\method{plot}{SNSeg_Uni}(x, cpts.col = "red", ...)
}
\arguments{
\item{x}{a \code{SNSeg_Uni} object}

\item{cpts.col}{a specification for the color of the vertical lines at
the change point estimators, see \link[graphics]{par}}

\item{...}{additional graphical arguments, see \link[graphics]{plot}
and \link[graphics]{abline}. Users are allowed to enter their own title for
the univariate time series plot. The bivariate time series does not contain
this option.}
}
\description{
Plotting method for S3 objects of class \code{SNSeg_Uni}
}
\details{
The location of each change point estimator is plotted as a vertical line
against the input time series.
}
\examples{
\donttest{
set.seed(7)
ts <- MAR_Variance(2, "V1")
ts <- ts[,2]
# test the change in a single parameter (variance)
# grid_size defined
result <- SNSeg_Uni(ts, paras_to_test = "variance", confidence = 0.9,
                    grid_size_scale = 0.05, grid_size = 67,
                    plot_SN = FALSE, est_cp_loc = TRUE)
plot(result, cpts.col='red')
}

}
