% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeans_clustersRProg.R
\name{kmeans_clustersRProg}
\alias{kmeans_clustersRProg}
\title{K-means algorithm applied for different values of clusters}
\usage{
kmeans_clustersRProg(codebook, k = 5, times = 5, seed = NULL)
}
\arguments{
\item{codebook}{SOM codebook}

\item{k}{Maximum number of clusters (the function will be run from 2 to k clusters)}

\item{times}{Number of times the som_kmeansR function is iterated}

\item{seed}{Number for set.seed function}
}
\value{
This function returns a list containing the cluster number assignment for each sample,
the cluster centroids, the total quantization error, the DB-index for each number of clusters, and the random seed number used
}
\description{
The som_kmeansR function with 100 epochs training is run for a custom number of times for each k value of clusters
and the best of these is selected based on sum of squared errors (err).
The Davies-Bouldin index is calculated for each k-clustering.
The function has been coded in R code starting from kmeans_clusters.m
script present in somtoolbox for Matlab by Vesanto and adapted to show a progress bar when working embedded in the shiny app.
}
\references{
{J. Vesanto, J. Himberg, E. Alhoniemi, J. Parhankagas, SOM Toolbox for Matlab
5, Report A57, 2000, Available at: www.cis.hut.fi/projects/somtoolbox/package/papers/techrep.pdf
}
}
\seealso{
som_mdistR, som_kmeansRProg, db_indexR
}
\author{
Sabina Licen, Pierluigi Barbieri
}
