% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average.neur.property.R
\name{average.neur.property}
\alias{average.neur.property}
\title{Compute average property}
\usage{
average.neur.property(SOM, P)
}
\arguments{
\item{SOM}{the SOM object to cluster}

\item{P}{the property for each frame of the simulation}
}
\value{
The a vector with the per-neuron average of the property.
}
\description{
Function to compute the average value of a property for each neuron.
}
\examples{
#Read trajectory
trj <- read.trj(trjfile = system.file("extdata", "HIF2a-MD.xtc", package = "SOMMD"),
  topfile = system.file("extdata", "HIF2a.gro", package = "SOMMD"))
#Read example SOM data
som_model <- readRDS(system.file("extdata", "SOM_HIFa.rds", package = "SOMMD"))
#Compute distance between two atoms in every frame of the simulation
Distance <- apply(trj$coord[c(162,1794),,], 3, dist)
#Compute average property value for each neuron
avg.p <- average.neur.property(som_model, Distance)

}
\author{
Stefano Motta \email{stefano.motta@unimib.it}
}
