% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.pathways.R
\name{cluster.pathways}
\alias{cluster.pathways}
\title{Clustering of Pathways}
\usage{
cluster.pathways(
  SOM,
  start,
  end,
  time.dep = "independent",
  method = "complete"
)
}
\arguments{
\item{SOM}{a kohonen SOM object.}

\item{start}{the vector specifying the starting frame of each replicas}

\item{end}{the vector specifying the ending frame of each replicas}

\item{time.dep}{choose whether to use time "dependent" or "independent" clustering of pathways}

\item{method}{the method to be passed to hclust for the clustering}
}
\value{
representatives a vector of frames representatives of each neuron
}
\description{
Cluster pathways according to a time dependent or independent scheme
}
\examples{
#Read trajectory
trj <- read.trj(trjfile = system.file("extdata", "HIF2a-MD.xtc", package = "SOMMD"),
  topfile = system.file("extdata", "HIF2a.gro", package = "SOMMD"))
#Assign length of the replicas
trj$start <- seq(1, 25, by=5)
trj$end <- seq(5, 25, by=5)
#Read example SOM data
som_model <- readRDS(system.file("extdata", "SOM_HIFa.rds", package = "SOMMD"))
#Cluster Pathways using the time dependent algorithm
clus.paths.tdep <- cluster.pathways(som_model, start=trj$start, end=trj$end,
  time.dep="dependent")
#Cluster Pathways using the time independent algorithm
clus.paths.tindep <- cluster.pathways(som_model,
  start=trj$start, end=trj$end, time.dep="independent")

}
\author{
Stefano Motta\email{stefano.motta@unimib.it}
}
