% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neur.population.R
\name{neur.population}
\alias{neur.population}
\title{Get Neuron Population}
\usage{
neur.population(SOM, start = 1, end = length(SOM$unit.classif), N = 1)
}
\arguments{
\item{SOM}{the SOM object}

\item{start}{a vector containing the start frames of each replica (usually contained in trj$start if replicas were merged with cat_trj)}

\item{end}{a vector containing the end frames of each replica (usually contained in trj$end if replicas were merged with cat_trj)}

\item{N}{An integer for the portion (replica) of the simulations to be plotted}
}
\value{
A vector containing the per-neuron population
}
\description{
Function to compute the per-neuron population
}
\examples{
#Read example SOM data
som_model <- readRDS(system.file("extdata", "SOM_HIFa.rds", package = "SOMMD"))
pop <- neur.population(som_model)

}
\author{
Stefano Motta \email{stefano.motta@unimib.it}
}
