% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.trj.R
\name{read.trj}
\alias{read.trj}
\title{Read trj file}
\usage{
read.trj(trjfile, topfile)
}
\arguments{
\item{trjfile}{contains the name and the path to the reference file (pdb or gro files are accepted)}

\item{topfile}{contains the name and the path to the trajectory file (xtc or dcd files are accepted)}
}
\value{
Returns a list of class "trj" with the following components:

\item{topfile}{ the input topology file.}

\item{topformat}{ the format of the input topology.}

\item{trjfile}{ the input trajectory file.}

\item{trjformat}{ the format of the input trajectory.}

\item{coord}{ a three dimensional array containing atomic coordinates for all the frames. Dimensions are: Natoms:3:Nframes.}

\item{top}{  a data.frame containing topological informations with a row per atom and a column per record type (resno, resid, elety, eleno, chain).}

\item{start}{ a vector with the first frame of the simulation. When multiple simulations are concatenated with \code{cat.trj} the vector indicates the first frame of each simulation.}

\item{end}{ a vector with the last frame of the simulation. When multiple simulations are concatenated with \code{cat.trj} the vector indicates the last frame of each simulation.}

\item{call}{ the matched call.}
}
\description{
Function to read a trajectory file
}
\examples{
#Read trajectory
trj <- read.trj(trjfile = system.file("extdata", "HIF2a-MD.xtc", package = "SOMMD"),
  topfile = system.file("extdata", "HIF2a.gro", package = "SOMMD"))
}
\author{
Alessandro Pandini
}
