% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPARRAfairness_functions.R
\name{roc_2panel}
\alias{roc_2panel}
\title{roc_2panel
Draws a ROC curve (with legend) with a second panel underneath showing sensitivity difference.}
\usage{
roc_2panel(
  rocs,
  labels = names(rocs),
  col = 1:length(rocs),
  xy_col = phs_colours("phs-magenta"),
  highlight = NULL,
  yrange_lower = NULL,
  legend_title = ""
)
}
\arguments{
\item{rocs}{list of sparraROC objects}

\item{labels}{labels to use in legend; default to names of rocs.}

\item{col}{line colours}

\item{xy_col}{line colour for x-y line, defaults to red}

\item{highlight}{if non-null, add a point at this cutoff}

\item{yrange_lower}{y range for lower plot. If NULL, generates automatically}

\item{legend_title}{title for legend, defaults to nothing}
}
\value{
Invisibly returns plot as ggplot object
}
\description{
roc_2panel
Draws a ROC curve (with legend) with a second panel underneath showing sensitivity difference.
}
\examples{
# See vignette
}
