% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createpb.R
\name{create_pb}
\alias{create_pb}
\title{Function to create a simple progress bar}
\usage{
create_pb(
  length,
  remaining = "-",
  done = "=",
  percentage = TRUE,
  message = TRUE,
  custom.message = NULL,
  trim = 6L,
  print = TRUE,
  colour = "red",
  bg.colour = "white"
)
}
\arguments{
\item{length}{Length of the progress bar. For instance, in a loop it would be the number of iterations to complete.}

\item{remaining}{The character (string of unitary length) used to represent operations still to do.}

\item{done}{The character (string of unitary length) used to represent operations already completed}

\item{percentage}{Logical |  Whether to print the percentage progess after the bar. Defaults to \code{TRUE}}

\item{message}{Logical |  Whether to print a message before the progress bar. Defaults to \code{TRUE}}

\item{custom.message}{Optional message to be printed before the progress bar. Defaults to \code{NULL}, which prints simply \code{'Progress status:'},}

\item{trim}{How many points to trim from the maximum length of the terminal output. Default to \code{6L}}

\item{print}{Logical | Whether to print the progress bar after its initialisation. Defaults to \code{TRUE}}

\item{colour}{Styling of the progress bar object. It can be a single string, in which case it applies to all the part of the progress bar (message, bar and percentage). It can also be a vector of length 3, in which case each string applies to one of the items (respectively message, bar and percentage). The strings must be taken amongst the following values:
\itemize{
\item black;
\item blue;
\item cyan;
\item green;
\item magenta;
\item red;
\item white;
\item yellow.
}}

\item{bg.colour}{Styling of the progress bar object's background. It can be a single string, in which case it applies to all the part of the progress bar (message, bar and percentage). It can also be a vector of length 3, in which case each string applies to one of the items (respectively message, bar and percentage). The strings must be taken amongst the following values:
\itemize{
\item Black;
\item Blue;
\item Cyan;
\item Green;
\item Magenta;
\item Red;
\item White;
\item Grey;
\item Yellow.
}}
}
\value{
An object of the S4 class \code{simple.progess.bar} containing:
\item{message}{A string representing the message to be printed together with the bar}
\item{bar}{The progress bar}
\item{percentage}{Progress in percentage}
\item{length}{Length of the progress bar (integer)}
\item{remaining}{Character representing the remaining operations}
\item{done}{Character representing the operations already completed}
\item{style_msg}{Styling of \code{message} using \code{crayon}}
\item{style_bar}{Styling of \code{bar} using \code{crayon}}
\item{style_perc}{Styling of \code{percentage} using \code{crayon}}
}
\description{
Function to create a simple progress bar
}
\examples{

# Example without custom colours or custom message
pb<-create_pb(length=10, print=TRUE)

# Example without custom colours but with custom message
pb<-create_pb(length=10, custom.message = 'Custom progress message:',
print = TRUE)

# Example with custom colours and custom message
pb<-create_pb(length=10, custom.message = 'Custom progress message:',
print = TRUE,colour = c('magenta','red','blue'))

}
\author{
\enc{Telarico, Fabio Ashtar}{Fabio Ashtar Telarico}
}
