% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPEVfunctions.R
\name{smoothed_penalized_EV}
\alias{smoothed_penalized_EV}
\title{smoothed_penalized_EV}
\usage{
smoothed_penalized_EV(m, lambda, k, mu)
}
\arguments{
\item{m}{A matrix generated from a large dataset.}

\item{lambda}{A numeric vector of lambda values to use for the penalty.}

\item{k}{The number of eigenvectors we consider in the analysis.}

\item{mu}{A number assigned to mu; we are typically using 0.1.}
}
\value{
Returns smoothed eigenvectors 1 to k for the specified lambda value.
}
\description{
This function takes a matrix (m), a lambda value (lambda), the number
of desired eigenvectors (k), and a mu value (mu) as input. It then computes
eigenvectors 1 to k, penalized by the supplied lambda and smoothed by the
Nesterov smoothing function.
}
\examples{
# Generate a small matrix for testing
m <- matrix(rnorm(100), nrow = 10)
# Call function (using matrix, lambda, mu, and k)
smoothed_penalized_EV(
  m = m,
  lambda = 1,
  k = 2,
  mu = 0.1
)
}
